Severity <- function(Basin_Events, Sites){
  library(IRanges)
  Severity <- NULL
  SeverityIDX <- NULL
  Overlap <- IRanges((Basin_Events$Event_Base), Basin_Events$Event_End)
  Basin_Events$Group <- subjectHits(findOverlaps(Overlap, reduce(Overlap)))
  
  Effected <- data.frame(aggregate(Basin_Events$Site_ID, by = list(Basin_Events$Group), function(x) length(unique(x))))
  
  Discharge <- data.frame(aggregate(Basin_Events$Peak_Discharge, by = list(Basin_Events$Site_ID, Basin_Events$Group), function(x) max(x)))
  colnames(Discharge) <- c("Site_ID","Group","Peak_Discharge")
  
  Peak_Discharge <- data.frame(aggregate(Discharge$Peak_Discharge, by = list(Discharge$Group), function(x) sum(x)))
  
  
  for (i in 1:nrow(Effected)){
    SeverityIDX[i] <- ((Peak_Discharge[i,2])/nrow(Sites)) 
  }
    
  Severity <- data.frame(Effected = Effected[,2], Total_Discharge = Peak_Discharge[,2], Severity = SeverityIDX)
}